/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.comm;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class VirtualDeviceDataTransfer
extends DataTransfer {
    protected Hashtable memory;
    private Vector inited = new Vector();

    public VirtualDeviceDataTransfer() {
        this.memory = new Properties();
    }

    public VirtualDeviceDataTransfer(Hashtable memory) {
        this.memory = new Hashtable(memory);
    }

    public void closePort() {
    }

    public void dump() {
        Enumeration e = this.memory.keys();
        Integer key = null;
        Integer value = null;
        while (e.hasMoreElements()) {
            key = (Integer)e.nextElement();
            value = (Integer)this.memory.get(key);
            System.out.println(Integer.toHexString(key) + "=" + Integer.toHexString(value));
        }
    }

    private int getByteFromMemory(int address) {
        Integer i = (Integer)this.memory.get(new Integer(address));
        if (i == null) {
            i = new Integer(0);
        }
        return i;
    }

    public Hashtable getMemory() {
        return this.memory;
    }

    private int getMinimalAddress(Hashtable memory) {
        int minimalAddress = Integer.MAX_VALUE;
        int currentAddress = -1;
        Enumeration e = memory.keys();
        while (e.hasMoreElements()) {
            currentAddress = (Integer)e.nextElement();
            if (currentAddress >= minimalAddress) continue;
            minimalAddress = currentAddress;
        }
        return minimalAddress;
    }

    public int handleError(int error, boolean retry) {
        return 0;
    }

    private void putByteIntoMemory(int address, int value) {
        this.memory.put(new Integer(address), new Integer(value));
        if (!this.inited.contains(address)) {
            this.inited.add(address);
        } else {
            System.err.println("Error at " + Integer.toHexString(address));
        }
    }

    public int readByte(int adr) throws TransmissionFailedException {
        this.fLastAddress = adr;
        return this.getByteFromMemory(adr);
    }

    public int uploadHardwareID() throws TransmissionFailedException {
        int retWert = this.isAddress32() ? this.readByte(16719618) & 0xFF : this.readByte(7938) & 0xFF;
        return retWert;
    }

    protected int[] readBytes(int adr, int count) throws TransmissionFailedException {
        int[] tempArray = new int[count];
        for (int i = 0; i < count; ++i) {
            tempArray[i] = this.getByteFromMemory(adr + i);
        }
        return tempArray;
    }

    public void readHexFromReader(BufferedReader reader) throws IOException {
        this.memory = new Hashtable();
        String line = null;
        int currentAddress = 0;
        int value = 0;
        while ((line = reader.readLine()) != null) {
            if (line.equals("")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            currentAddress = Integer.parseInt(tokenizer.nextToken(), 16);
            while (tokenizer.hasMoreTokens()) {
                try {
                    value = Integer.parseInt(tokenizer.nextToken(), 16);
                    this.memory.put(new Integer(currentAddress++), new Integer(value));
                }
                catch (NumberFormatException e) {
                    System.err.println("NumberformatException at adress:" + currentAddress);
                    e.printStackTrace();
                }
            }
        }
    }

    public int readNextByte() throws TransmissionFailedException {
        this.nextAddress();
        return this.readByte(this.fLastAddress);
    }

    public void reset() {
        this.fByteCount = 0;
    }

    protected void resetInternal() {
    }

    public void setMemory(Properties newMemory) {
        this.memory = newMemory;
    }

    public String toString() {
        return Language.getString("msg.com.TransferVia", "Transfer via ") + " int-Array (int[])";
    }

    protected void writeByte(int adr, int writeValue, int timeout) throws TransmissionFailedException {
        this.fLastAddress = adr;
        this.putByteIntoMemory(adr, writeValue);
    }

    protected void writeBytes(int adr, int[] writeValue) throws TransmissionFailedException {
        this.fLastAddress = adr;
        for (int i = 0; i < writeValue.length; ++i) {
            this.putByteIntoMemory(adr + i, writeValue[i]);
        }
    }

    public void writeHexToWriter(BufferedWriter writer) throws IOException {
        int lastWrittenAddress = -1;
        int LastBlockStartAddress = -1;
        Hashtable outputMemory = (Hashtable)this.memory.clone();
        while (outputMemory.size() > 0) {
            int minAddress = this.getMinimalAddress(outputMemory);
            if (lastWrittenAddress > minAddress + 1 || minAddress - LastBlockStartAddress >= 16 || minAddress - lastWrittenAddress > 1) {
                if (lastWrittenAddress > minAddress + 1 || minAddress - lastWrittenAddress > 1) {
                    writer.newLine();
                }
                writer.newLine();
                writer.write(Integer.toHexString(minAddress));
                lastWrittenAddress = minAddress - 1;
                LastBlockStartAddress = minAddress;
            }
            writer.write(" ");
            Integer value = (Integer)outputMemory.get(new Integer(minAddress));
            writer.write(Integer.toHexString(value));
            outputMemory.remove(new Integer(minAddress));
            ++lastWrittenAddress;
        }
    }

    public void writeNextByte(int value) throws TransmissionFailedException {
        this.nextAddress();
        this.writeByte(this.fLastAddress, value);
    }

    public void writeHardwareID(int hardwareID) throws TransmissionFailedException {
        this.writeCommandByte(7938, hardwareID, 0);
    }

    protected int getReadByteRetryTimes() {
        return 0;
    }

    protected void resetInternalWait() {
    }

    public void rebuildConnection() throws ExceptionAlreadyHandledException {
    }
}

